//ESP32 S cu libr
//Adafruit Keypad
//pass cu 3 cifre
//led pe GPOI 12 sta aprins 2 sec apoi se stinge
//am introdus clear data in void loop
//Oled conectat: SDA la GPIO21 SCK la GPIO22

/*
  prin router local  
  dupa incarcare pe Serial monitor apare adresa IP 192.169.0.102
  pe Android Chrome
  se introdice 192.16.0.102/webserial
  apare pagina web
  tot ce este editat pe telefon apare pe Serial Monitor
  comand led pe GPIO 14 prin on si off
*/
#include <Arduino.h>
#include <WiFi.h>
#include <AsyncTCP.h>
#include <ESPAsyncWebServer.h>
#include <WebSerial.h>
#define LED 14
AsyncWebServer server(80);
const char* ssid = "SSID router";          
const char* password = "password router";

#include <Keypad.h>
 
// lungime password + 1 for null character
// trebuie sa fie cu 1 mai lung decat password
#define Password_Length 5 

char Data[Password_Length];
char Master[Password_Length] = "123B";
//pass cu 3 caractere
 
// led sau releu pe GPIO 12
int led1 = 12; 

// Counter for character entries
byte data_count = 0;
char key;

const byte ROWS = 4;
const byte COLS = 4;
 
// numarul de linii si coloane
//se poate atribui orice caracter
char hexaKeys[ROWS][COLS] = {
  
  {'1', '2', '3', 'A'},
  {'4', '5', '6', 'B'},
  {'7', '8', '9', 'C'},
  {'*', '0', '#', 'D'}
      };

// conectare keypad la ESP32
byte rowPins[ROWS] = {19, 18, 5, 17};
byte colPins[COLS] = {16, 4, 0, 2};
 
// Create keypad object
Keypad keypad = Keypad(makeKeymap(hexaKeys), rowPins, colPins, ROWS, COLS);

#include <Adafruit_SSD1306.h>
#include <Adafruit_GFX.h>
#define OLED_ADDR   0x3C
Adafruit_SSD1306 display(-1);


void recvMsg(uint8_t *data, size_t len){
  WebSerial.println("Received Data...");
  String d = "";
  for(int i=0; i < len; i++){
    d += char(data[i]);
    Serial.println(d);
    display.clearDisplay();
  display.setTextSize(2);
  display.setTextColor(WHITE);
  display.setCursor(0,0);
  display.print("Primit=");
  display.print(d);//afiseaza text tranmmsis pe oled
  display.display();
  }
//led pe GPOI14 comandat separat de mesjele ON si OFF  
  if (d == "on"){
    digitalWrite(LED, HIGH);
  }
  if (d=="off"){
    digitalWrite(LED, LOW);
  }
}
 
void setup() {
 Serial.begin(115200);
 
  pinMode(led1, OUTPUT);
  pinMode(LED, OUTPUT);
  WiFi.mode(WIFI_STA);
  WiFi.begin(ssid, password);
  if (WiFi.waitForConnectResult() != WL_CONNECTED) {
    Serial.printf("WiFi Failed!\n");
    return;
  }
  Serial.print("IP Address: ");
  Serial.println(WiFi.localIP());
  WebSerial.begin(&server);
  WebSerial.msgCallback(recvMsg);
  server.begin();
  display.begin(SSD1306_SWITCHCAPVCC, OLED_ADDR);
  display.clearDisplay();
  display.setTextSize(2);
  display.setTextColor(WHITE);
  display.setCursor(0,0);
  display.print("webserial IP=");
  display.print(WiFi.localIP());
  display.print("/webserial"); 
  display.display();
  delay(5000);
    }
 
void loop() { 
  // Look for keypress
  key = keypad.getKey();
  if (key) {
    // Enter keypress into array and increment counter
    Data[data_count] = key;
    data_count++;
    Serial.print("data ");
    Serial.println(Data);
   //afiseaza caractere pe Oled
  display.clearDisplay();
  display.setTextSize(2);
  display.setTextColor(WHITE);
  display.setCursor(0,0);
  display.print("cod=");
  display.print(Data); 
  //afiseaza corect in format DEC
  display.display();    
    }
 
  // compara codul introduse cu passwordul
  if (data_count == Password_Length - 1) {   
    if (!strcmp(Data, Master)) {
      // Turn on relay for 2 seconds
      digitalWrite(led1, HIGH);     
      Serial.println("cod OK ");
    delay(2000);
      digitalWrite(led1, LOW);
      WebSerial.println("cod OK");
      WebSerial.println(Data);
      display.print(" access OK");  
      display.display();
      delay(3000);
      display.clearDisplay();
      
    }
    else {
      // Password is incorrect
      Serial.println("cod incorect ");  
      WebSerial.println("cod incorect");
      WebSerial.println(Data);  
      delay(1000);
      display.print(" access denied"); 
      display.display();
      delay(3000);
      display.clearDisplay();
    }

  while (data_count != 0) {
    Data[data_count--] = 0;
    }
  return;
    //clearData();
    }
    }

//am introdus clear data in void loop
 
